;JoyTail v1.0.1 Beta

#SingleInstance Force
#NoEnv
SendMode Input
SetTitleMatchMode 2

NetworkAddress = 127.0.0.1 ;Localhost
NetworkPort    = 42001     ;Scratch Port.
MaxDataLength  = 512       ;Longest message that can be recieved.
Delay          = 16         ;ms to wait between sends.
Debug          = 0         ;0=Off, 1=Log errors, 2=Log more stuff.

DetectHiddenWindows On
Process Exist
MainWindow := WinExist("ahk_class AutoHotkey ahk_pid " ErrorLevel)
DetectHiddenWindows Off

OnExit DoExit
OnMessage(5555, "ReceiveData", 99) ;Allow 99 (i.e. lots of) threads.

Menu, Tray, Icon,,, 1
Menu TRAY, Tip, JoyTail (Waiting.)
If A_IsCompiled
{
   Menu TRAY, NoStandard
   Menu TRAY, Add, Exit, DoExit
   Menu TRAY, Icon, %A_ScriptFullPath%, 2 ;R 28, Y 48, G 177
}
Else
   Menu TRAY, Icon, SHELL32.DLL, 28
Menu TRAY, Add, Connect, Connect
Menu TRAY, Default, Connect
Menu TRAY, Click, 1
MainSocket := -1

Goto Start

Connect:
Menu TRAY, Tip, JoyTail (Connecting...)
Menu TRAY, Rename, Connect, Disconnect
Menu TRAY, Add, Disconnect, Disconnect
Menu TRAY, Click, 2
OopsClick := A_TickCount
SetTimer TryConnect, -1
If A_IsCompiled
   Menu TRAY, Icon, %A_ScriptFullPath%, 3
Else
   Menu TRAY, Icon, SHELL32.DLL, 45
Return

Disconnect:
If (A_TickCount - OopsClick < 1000)
   Return
If (MainSocket = -1)
{
   SetTimer TryConnect, Off
   Menu TRAY, Tip, JoyTail (Waiting.)
   Menu TRAY, Rename, Disconnect, Connect
   Menu TRAY, Add, Connect, Connect
   Menu TRAY, Click, 1
   If A_IsCompiled
      Menu TRAY, Icon, %A_ScriptFullPath%, 2
   Else
      Menu TRAY, Icon, SHELL32.DLL, 28
}
Else
   Reload
Return

TryConnect:
MainSocket := PrepareSocket(NetworkAddress, NetworkPort)d
If (MainSocket = -1)
   SetTimer TryConnect, -1000
Else
{
   ;FD_READ + FD_CLOSE + FD_WRITE = 35
   If DllCall("Ws2_32\WSAAsyncSelect", "UInt", MainSocket, "UInt", MainWindow, "UInt", 5555, "Int", 35)
      LogError(A_ThisFunc "() " A_ThisLabel ": " "WSAAsyncSelect() indicated Winsock error " DllCall("Ws2_32\WSAGetLastError"))
   Menu TRAY, Tip, JoyTail (Connected to Scratch!)
   If A_IsCompiled
      Menu TRAY, Icon, %A_ScriptFullPath%, 4
   Else
      Menu TRAY, Icon, SHELL32.DLL, 177
   GoSub OnConnect
}
Return

DoExit:
DllCall("Ws2_32\WSACleanup")
ExitApp

PrepareSocket(IPAddress, Port)
{
   VarSetCapacity(wsaData, 32)
   Result := DllCall("Ws2_32\WSAStartup", "UShort", 0x0002, "UInt", &wsaData)
   If ErrorLevel
      LogError(A_ThisFunc "() " A_ThisLabel ": " "WSAStartup() could not be called due to error" ErrorLevel ". Winsock 2.0 or higher is required.")
   If Result  ; Non-zero, which means it failed (most Winsock functions return 0 upon success).
      LogError(A_ThisFunc "() " A_ThisLabel ": " "WSAStartup() indicated Winsock error " DllCall("Ws2_32\WSAGetLastError"))

   ;AF_INET = 2   SOCK_STREAM = 1   IPPROTO_TCP = 6
   Socket := DllCall("Ws2_32\socket", "Int", 2, "Int", 1, "Int", 6)
   If (Socket = -1)
      LogError(A_ThisFunc "() " A_ThisLabel ": " "Socket() indicated Winsock error " DllCall("Ws2_32\WSAGetLastError"))

   VarSetCapacity(SocketAddress, 16)
   InsertInteger(2, SocketAddress, 0, 2) ; AF_INET = 2
   InsertInteger(DllCall("Ws2_32\htons", "UShort", Port), SocketAddress, 2, 2)   ; sin_port
   InsertInteger(DllCall("Ws2_32\inet_addr", "Str", IPAddress), SocketAddress, 4, 4)   ; sin_addr.s_addr

   If DllCall("Ws2_32\connect", "UInt", Socket, "UInt", &SocketAddress, "Int", 16)
   {
      Result := DllCall("Ws2_32\WSAGetLastError")
      If (Result != 10061)
         LogError(A_ThisFunc "() " A_ThisLabel ": " "Connect() indicated Winsock error " Result)
      return -1
   }

   Return Socket
}

ReceiveData(wParam, lParam)
{
   Global MaxDataLength, MainSocket
   If (MainSocket = -1)
      Return 1

   VarSetCapacity(ReceivedData, MaxDataLength, 0)
   ReceivedDataLength := DllCall("Ws2_32\recv", "UInt", wParam, "Str", ReceivedData, "Int", MaxDataLength, "Int", 0)
   If (ReceivedDataLength = 0)
      Return 1
   If ReceivedDataLength = -1
   {
      WinsockError := DllCall("Ws2_32\WSAGetLastError")
      If (WinsockError = 10035)  ; No more data to be read
      {
         Return 1
      }
      If (WinsockError = 10054) ; Connection closed
      {
         Reload
      }
      LogError(A_ThisFunc "() " A_ThisLabel ": " "Recv() indicated Winsock error " WinsockError)
   }

   ParseMessage(ReceivedData)

   Return 1
}

SendData(Socket, ByRef Data)
{
   Global SLOWDOWN
   If (Socket = -1)
      Return -1

   SendRet := DllCall("Ws2_32\send", "UInt", Socket, "Str", Data, "Int", StrLen(Data), "Int", 0)
   If (SendRet = -1)
   {
      WinsockError := DllCall("Ws2_32\WSAGetLastError")
      LogError(A_ThisFunc "() " A_ThisLabel ": " "Send() indicated Winsock error " WinsockError)
   }
   Return SendRet
}

InsertInteger(pInteger, ByRef pDest, pOffset = 0, pSize = 4)
{
   Loop %pSize%  ; Copy each byte in the integer into the structure as raw binary data.
      DllCall("RtlFillMemory", "UInt", &pDest + pOffset + A_Index-1, "UInt", 1, "UChar", pInteger >> 8*(A_Index-1) & 0xFF)
}

LogError(Msg)
{
   Global Debug
   If Debug
      FileAppend %Msg%`n, Debug.txt
   Sleep 1000
   Reload
}

;#IfWinActive Scratch ahk_class SqueakWindowClass

;Above this line, junk you probably don't want to mess with. (But feel free!)
;*****************************************************************************
;Below this line, semi-interesting functions.

ParseMessage(ByRef Message)
{
   Global

   ;InLen := NumGet(Message, 3, "UChar")
   Message := DllCall("MulDiv", int, &Message+4, int, 1, int, 1, str)

   ;MsgBox {%MsgSock%} (%InLen%) [%Message%]

   Message := RegExReplace(Message, "([^ ])""Scratch-", "$1 ""Scratch-")
   Message := RegExReplace(Message, "([^""]) ([^""])", "$1_$2")
   StringSplit Arg, Message, %A_Space%, "

   If (Debug = 2)
   {
      FileAppend %Message%`n, Debug.txt
      Loop %Arg0%
         FileAppend % Arg%A_Index% "`n", Debug.txt
   }

   If (Arg1 = "broadcast")
   {
      If (Arg2 = "Scratch-StartClicked")
         GoSub GreenFlag
      Else If IsLabel("Scratch_" Arg2)
         GoSub Scratch_%Arg2%
      Else
      {
         Broadcast := Arg2
         GoSub Broadcast
      }
   }
   If (Arg1 = "sensor-update")
   {
      Index := 2
      While (Index < Arg0)
      {
         VarName := Arg%Index%
         StringReplace, VarName, VarName, -, _, All
         Index += 1
         %VarName% := Arg%Index%
         If Debug
            FileAppend % VarName " := " Arg%Index% "`n", Debug.txt
         Index += 1
      }
      GoSub VarChange
   }
}

Broadcast(Cast)
{
   Global MainSocket
   Message := "broadcast """ Cast """"
   OutLen := StrLen(Message)
   Message := "XXXX" Message
   NumPut(0, Message, 0, "UInt")
   NumPut(OutLen, Message, 3, "UChar")
   SendData(MainSocket, Message)
   Sleep %Delay%
}

Update(Var = "", Val = "", Wait = 0)
{
   Global MainSocket, Delay
   Static OutMsg
   If (Var != "")
   {
      If (OutMsg = "")
         OutMsg := "sensor-update"
      If Val Is Number
         OutMsg .= " """ Var """ " Val
      Else
         OutMsg .= " """ Var """ """ Val """"
   }
   If (OutMsg AND NOT Wait)
   {
      OutLen := StrLen(OutMsg)
      OutMsg := "XXXX" OutMsg
      NumPut(0, OutMsg, 0, "UInt")
      NumPut(OutLen, OutMsg, 3, "UChar")
      SendData(MainSocket, OutMsg)
      OutMsg =
      Sleep %Delay%
   }
}

;******************** (Your custom code starts here.) ********************
                           ;Your hotkeys here.
~F1::Broadcast("Help")
;                        ***************************
Start:        ;Anything you want to do even before connecting.
IfNotExist JoyTail.ini
{
   FileAppend [Joystick]`n`n[General]`n`n, JoyTail.ini
   TrayTip JoyTail, Click - Connect`nDouble-Click - Disconnnect`nRight-Click - More Options, 30, 1
}
IniRead J, JoyTail.ini, Joystick, JoystickNum, 1
IniRead Buttons, JoyTail.ini, Joystick, Buttons, 32
IniRead PreloadButtons, JoyTail.ini, Joystick, PreloadButtons, 4
IniRead XAxis, JoyTail.ini, Joystick, XAxis, 1
IniRead YAxis, JoyTail.ini, Joystick, YAxis, 1
IniRead ZAxis, JoyTail.ini, Joystick, ZAxis, 0
IniRead RAxis, JoyTail.ini, Joystick, RAxis, 0
IniRead UAxis, JoyTail.ini, Joystick, UAxis, 0
IniRead VAxis, JoyTail.ini, Joystick, VAxis, 0
IniRead HasPOV, JoyTail.ini, Joystick, HasPOV, 0

IniRead Delay, JoyTail.ini, General, Delay, %Delay%
IniRead ClearScreenSaver, JoyTail.ini, General, ClearScreenSaver, 1
IniRead ScratchOnTopOnly, JoyTail.ini, General, ScratchOnTopOnly, 0
IniRead Debug, JoyTail.ini, General, Debug, %Debug%
XYZRUV = XYZRUV

Gui Add, Text, xm ym+4, Joystick #:
Gui Add, Edit, ym w32
Gui Add, UpDown, vJ gSelectJoyStick Range1-32
Gui Add, Text, ym x112 w200 r1.5 vJoyName +0x1000 

Gui Add, GroupBox, xm y32 w336 h96, Joystick Details
Gui Add, Button, xp+8 yp+20 Section gAutoDetect, Auto Detect
Gui Add, Text, ys+4, Buttons:
Gui Add, Edit, ys w32
Gui Add, UpDown, vButtons gButtonSpinners Range0-32
Gui Add, Text, ys+4, Preload:
Gui Add, Edit, ys w32
Gui Add, UpDown, vPreloadButtons gButtonSpinners Range0-32
Gui Add, Checkbox, xs w64 Section vXAxis, X-Axis
Gui Add, Checkbox, ys w64 vYAxis, Y-Axis
Gui Add, Checkbox, ys w64 vZAxis, Z-Axis
Gui Add, Checkbox, ys vRAxis, R-Axis (Rudder)
Gui Add, Checkbox, xs w64 Section vUAxis, 5th Axis
Gui Add, Checkbox, ys w64 vVAxis, 6th Axis
Gui Add, Checkbox, ys vHasPOV, POV (Hat Switch)

Gui Add, Text, xm Section
Gui Add, Text, xm yp+4, Delay:
Gui Add, Edit, ys w32
Gui Add, UpDown, vDelay Range0-1000
Gui Add, Text, ys+4, (Raise this if Scratch has trouble keeping up.)
Gui Add, Checkbox, xm vClearScreenSaver, Buttons Clear Screen Saver
Gui Add, Checkbox, xm vScratchOnTopOnly, Active only when Scratch has focus.
Gui Add, Button, xm w112 Section Default, OK
Gui Add, Button, xm+224 ys w112 Cancel, Cancel

Menu TRAY, Add, Configure

;GoSub Configure

Return

;                        ***************************
OnConnect:                  ;Your main code here.
GUIState := 0

Axes = 
Loop Parse, XYZRUV
   If %A_LoopField%Axis
      Axes .= A_LoopField

Loop %Buttons%
   HotKey %J%Joy%A_Index%, AnyButton

Loop %PreloadButtons%
   Update("Joy" A_Index, 0, !Mod(A_Index, 8))

Loop Parse, Axes
   LJoy%A_LoopField% =
If HasPOV
   JoyPOV =
StringReplace Axes, Axes, Y

Loop
{
   While (ScratchOnTopOnly AND NOT WinActive("Scratch ahk_class SqueakWindowClass"))
      Suspend On
   Suspend Off

   Loop %Buttons%
   {
      Joy%A_Index% := GetKeyState(J "Joy" A_Index)
      If (Joy%A_Index% = !LJoy%A_Index%)
      {
         Update("Joy" A_Index, (LJoy%A_Index% := Joy%A_Index%))
         If (Joy%A_Index%)
            Broadcast("Joy" A_Index)
      }
   }

   Loop Parse, Axes
   {
      Joy%A_LoopField% := GetKeyState(J "Joy" A_LoopField)*2-100
      If (Joy%A_LoopField% != LJoy%A_LoopField%)
         Update("Joy" A_LoopField, (LJoy%A_LoopField% := Joy%A_LoopField%), 1)
   }
   If YAxis
   {
      JoyY := GetKeyState(J "JoyY")*-2+100 ;Inverted
      If (JoyY != LJoyY)
         Update("JoyY", (LJoyY := JoyY), 1)
   }
   If HasPOV
   {
      JoyPOV := GetKeyState(J "JoyPOV")
      If (JoyPOV != -1)
         JoyPOV /= 100
      If (JoyPOV != LJoyPOV)
         Update("JoyPOV", (LJoyPOV := JoyPOV), 1)
   }
   Update()

   While (GUIState = 1)
         Continue
   If (GUIState = 2)
      Goto OnConnect
}
Return

AnyButton:
If ClearScreenSaver
   Send {NumpadClear}
Return

Configure:
GUIState := 1
OldJ := J, OldButtons := Buttons, OldPreloadButtons := PreloadButtons

GuiControl,, J, %J%
GuiControl,, Buttons, %Buttons%
GuiControl,, PreloadButtons, %PreloadButtons%
Loop Parse, XYZRUV
   GuiControl,, %A_LoopField%Axis, % %A_LoopField%Axis
GuiControl,, HasPOV, %HasPOV%
GuiControl,, Delay, %Delay%
GuiControl,, ClearScreenSaver, %ClearScreenSaver%
GuiControl,, ScratchOnTopOnly, %ScratchOnTopOnly%

GoSub SelectJoyStick
Gui Show,, JoyTail
Return

SelectJoyStick:
GuiControl,, JoyName, % GetKeyState(J "JoyName")
Return

AutoDetect:
GuiControl,, Buttons, % GetKeyState(J "JoyButtons")
GuiControl,, PreloadButtons, % GetKeyState(J "JoyButtons")
Axes := "XY" GetKeyState(J "JoyInfo")
GuiControl,, HasPOV, % !!InStr(Axes, "P")
Loop Parse, XYZRUV
   GuiControl,, %A_LoopField%Axis, % !!InStr(Axes, A_LoopField)
Return

ButtonSpinners:
If (PreloadButtons > Buttons)
{
   PreloadButtons := Buttons
   GuiControl,, PreloadButtons, %PreloadButtons%
}
Return

ButtonOK:
Gui Submit
IniWrite %J%, JoyTail.ini, Joystick, JoystickNum
IniWrite %Buttons%, JoyTail.ini, Joystick, Buttons
IniWrite %PreloadButtons%, JoyTail.ini, Joystick, PreloadButtons
Loop Parse, XYZRUV
   IniWrite % %A_LoopField%Axis, JoyTail.ini, Joystick, %A_LoopField%Axis
IniWrite %HasPOV%, JoyTail.ini, Joystick, HasPOV
IniWrite %Delay%, JoyTail.ini, General, Delay
IniWrite %ClearScreenSaver%, JoyTail.ini, General, ClearScreenSaver
IniWrite %ScratchOnTopOnly%, JoyTail.ini, General, ScratchOnTopOnly
GUIState := 2
Return

ButtonCancel:
GuiEscape:
J := OldJ, Buttons := OldButtons, PreloadButtons := OldPreloadButtons
Gui Cancel
GUIState := 0
Return

;                        ***************************
VarChange:        ;Code to handle variable changes, if any.
Return

;                        ***************************
Broadcast:               ;Default broadcast handler.
;MsgBox Received "%Broadcast%".
Return

;                        ***************************
Scratch_SaveCookie:
IniWrite %Scratch_Cookie%, JoyTail.ini, Cookies, %Scratch_CookieName%
If (Debug = 2)
   FileAppend SAVED COOKIE %Scratch_CookieName% = %Scratch_Cookie%`n, Debug.txt
Return

Scratch_ReadCookie:
IniRead Scratch_Cookie, JoyTail.ini, Cookies, %Scratch_CookieName%, %A_Space%
Update("Cookie", Scratch_Cookie)
If (Debug = 2)
   FileAppend LOADED COOKIE %Scratch_CookieName% = %Scratch_Cookie%`n, Debug.txt
Return

;                        ***************************
GreenFlag:         ;Code for when the Green Flag is clicked.
Return